/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import com.aptana.core.util.ImmutableTuple;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.theme.ColorManager;
import com.aptana.theme.DelayedTextAttribute;
import com.aptana.theme.RGBa;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemeRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

class ThemeGetTextAttribute {
    private IScopeSelector lastSelectorMatch;
    private final ColorManager colorManager;
    private final Theme theme;
    private final RGB defaultFG;
    private final RGB defaultBG;
    private final Collection<IScopeSelector> selectors;
    private final Map<String, TextAttribute> cacheGetTextAttribute;
    private static volatile ImmutableTuple<ScopeSelector, DelayedTextAttribute>[] scopeToAttribute;
    private static volatile ImmutableTuple<ScopeSelector, DelayedTextAttribute>[] scopeToAttributeLight;
    private static volatile ImmutableTuple<ScopeSelector, DelayedTextAttribute>[] scopeToAttributeDark;
    private final Map<String, DelayedTextAttribute> cacheDelayedGetTextAttribute;

    public ThemeGetTextAttribute(Theme theme) {
        this.theme = theme;
        this.colorManager = theme.getColorManager();
        this.defaultFG = theme.getForeground();
        this.defaultBG = theme.getBackground();
        this.cacheGetTextAttribute = new HashMap<String, TextAttribute>();
        this.cacheDelayedGetTextAttribute = new HashMap<String, DelayedTextAttribute>();
        List<ThemeRule> tokens = theme.getTokens();
        this.selectors = new ArrayList<IScopeSelector>(tokens.size());
        for (ThemeRule rule : tokens) {
            if (rule.isSeparator()) continue;
            this.selectors.add(rule.getScopeSelector());
        }
    }

    IScopeSelector findMatch(String scope) {
        return ScopeSelector.bestMatch(this.selectors, (String)scope);
    }

    synchronized TextAttribute getTextAttribute(String scope) {
        TextAttribute ta = this.cacheGetTextAttribute.get(scope);
        if (ta != null) {
            return ta;
        }
        ta = this.internalGetTextAttribute(scope);
        this.cacheGetTextAttribute.put(scope, ta);
        return ta;
    }

    private TextAttribute internalGetTextAttribute(String scope) {
        this.lastSelectorMatch = null;
        TextAttribute ta = this.toTextAttribute(this.getDelayedTextAttribute(scope), true);
        return ta;
    }

    private DelayedTextAttribute getDelayedTextAttribute(String scope) {
        DelayedTextAttribute delayedTextAttribute = this.cacheDelayedGetTextAttribute.get(scope);
        if (delayedTextAttribute != null) {
            return delayedTextAttribute;
        }
        delayedTextAttribute = this.internalDelayedTextAttribute(scope);
        this.cacheDelayedGetTextAttribute.put(scope, delayedTextAttribute);
        return delayedTextAttribute;
    }

    private DelayedTextAttribute getParent(String scope) {
        DelayedTextAttribute parentAttr = null;
        int index = scope.lastIndexOf(32);
        if (index != -1) {
            String subType = scope.substring(0, index);
            parentAttr = this.getDelayedTextAttribute(subType);
        }
        if (parentAttr == null) {
            parentAttr = new DelayedTextAttribute(new RGBa(this.defaultFG), new RGBa(this.defaultBG), 0);
        }
        return parentAttr;
    }

    private DelayedTextAttribute internalDelayedTextAttribute(String scope) {
        ImmutableTuple<ScopeSelector, DelayedTextAttribute> tup;
        IScopeSelector match = this.findMatch(scope);
        if (match != null) {
            if (this.lastSelectorMatch != null && this.lastSelectorMatch.equals(match)) {
                return this.getParent(scope);
            }
            this.lastSelectorMatch = match;
            ThemeRule rule = this.theme.getRuleForSelector(match);
            DelayedTextAttribute attr = rule.getTextAttribute();
            if (attr.background == null || !attr.background.isFullyOpaque()) {
                DelayedTextAttribute parentAttr = this.getParent(scope);
                attr = this.merge(attr, parentAttr);
            }
            return attr;
        }
        if (scopeToAttribute == null) {
            this.initializeScopeToAttribute();
        }
        ImmutableTuple<ScopeSelector, DelayedTextAttribute>[] immutableTupleArray = scopeToAttribute;
        int n = scopeToAttribute.length;
        int n2 = 0;
        while (n2 < n) {
            tup = immutableTupleArray[n2];
            if (((ScopeSelector)tup.first).matches(scope)) {
                return (DelayedTextAttribute)tup.second;
            }
            ++n2;
        }
        if (this.theme.hasDarkBG()) {
            immutableTupleArray = scopeToAttributeDark;
            n = scopeToAttributeDark.length;
            n2 = 0;
            while (n2 < n) {
                tup = immutableTupleArray[n2];
                if (((ScopeSelector)tup.first).matches(scope)) {
                    return (DelayedTextAttribute)tup.second;
                }
                ++n2;
            }
        } else {
            immutableTupleArray = scopeToAttributeLight;
            n = scopeToAttributeLight.length;
            n2 = 0;
            while (n2 < n) {
                tup = immutableTupleArray[n2];
                if (((ScopeSelector)tup.first).matches(scope)) {
                    return (DelayedTextAttribute)tup.second;
                }
                ++n2;
            }
        }
        return new DelayedTextAttribute(new RGBa(this.defaultFG));
    }

    private void initializeScopeToAttribute() {
        scopeToAttribute = new ImmutableTuple[]{new ImmutableTuple((Object)new ScopeSelector("markup.changed"), (Object)new DelayedTextAttribute(new RGBa(255, 255, 255), new RGBa(248, 205, 14), 0)), new ImmutableTuple((Object)new ScopeSelector("markup.deleted"), (Object)new DelayedTextAttribute(new RGBa(255, 255, 255), new RGBa(255, 86, 77), 0)), new ImmutableTuple((Object)new ScopeSelector("markup.inserted"), (Object)new DelayedTextAttribute(new RGBa(0, 0, 0), new RGBa(128, 250, 120), 0)), new ImmutableTuple((Object)new ScopeSelector("markup.underline"), (Object)new DelayedTextAttribute(null, null, 0x40000000)), new ImmutableTuple((Object)new ScopeSelector("markup.bold"), (Object)new DelayedTextAttribute(null, null, 1)), new ImmutableTuple((Object)new ScopeSelector("markup.italic"), (Object)new DelayedTextAttribute(null, null, 2)), new ImmutableTuple((Object)new ScopeSelector("meta.diff.index"), (Object)new DelayedTextAttribute(new RGBa(255, 255, 255), new RGBa(65, 126, 218), 2)), new ImmutableTuple((Object)new ScopeSelector("meta.diff.range"), (Object)new DelayedTextAttribute(new RGBa(255, 255, 255), new RGBa(65, 126, 218), 2)), new ImmutableTuple((Object)new ScopeSelector("meta.separator.diff"), (Object)new DelayedTextAttribute(new RGBa(255, 255, 255), new RGBa(65, 126, 218), 2)), new ImmutableTuple((Object)new ScopeSelector("meta.diff.header"), (Object)new DelayedTextAttribute(new RGBa(255, 255, 255), new RGBa(103, 154, 233), 0)), new ImmutableTuple((Object)new ScopeSelector("meta.separator"), (Object)new DelayedTextAttribute(new RGBa(255, 255, 255), new RGBa(52, 103, 209), 0))};
        scopeToAttributeDark = new ImmutableTuple[]{new ImmutableTuple((Object)new ScopeSelector("console.error"), (Object)new DelayedTextAttribute(new RGBa(255, 0, 0), null, 0)), new ImmutableTuple((Object)new ScopeSelector("console.input"), (Object)new DelayedTextAttribute(new RGBa(95, 175, 176), null, 0)), new ImmutableTuple((Object)new ScopeSelector("console.prompt"), (Object)new DelayedTextAttribute(new RGBa(131, 132, 161), null, 0)), new ImmutableTuple((Object)new ScopeSelector("console.warning"), (Object)new DelayedTextAttribute(new RGBa(255, 215, 0), null, 0)), new ImmutableTuple((Object)new ScopeSelector("console.debug"), (Object)new DelayedTextAttribute(new RGBa(255, 236, 139), null, 0)), new ImmutableTuple((Object)new ScopeSelector("hyperlink"), (Object)new DelayedTextAttribute(new RGBa(84, 143, 160), null, 0))};
        scopeToAttributeLight = new ImmutableTuple[]{new ImmutableTuple((Object)new ScopeSelector("console.error"), (Object)new DelayedTextAttribute(new RGBa(255, 0, 0), null, 0)), new ImmutableTuple((Object)new ScopeSelector("console.input"), (Object)new DelayedTextAttribute(new RGBa(63, 127, 95), null, 0)), new ImmutableTuple((Object)new ScopeSelector("console.prompt"), (Object)new DelayedTextAttribute(new RGBa(42, 0, 255), null, 0)), new ImmutableTuple((Object)new ScopeSelector("console.warning"), (Object)new DelayedTextAttribute(new RGBa(205, 102, 0), null, 0)), new ImmutableTuple((Object)new ScopeSelector("console.debug"), (Object)new DelayedTextAttribute(new RGBa(93, 102, 102), null, 0)), new ImmutableTuple((Object)new ScopeSelector("hyperlink"), (Object)new DelayedTextAttribute(new RGBa(13, 17, 113), null, 0))};
    }

    private TextAttribute toTextAttribute(DelayedTextAttribute delayedOrTextAttr, boolean forceColor) {
        DelayedTextAttribute attr = delayedOrTextAttr;
        Color fg = null;
        if (attr.foreground != null || forceColor) {
            fg = this.colorManager.getColor(this.merge(attr.foreground, null, this.defaultFG).toRGB());
        }
        Color bg = null;
        if (attr.background != null || forceColor) {
            bg = this.colorManager.getColor(this.merge(attr.background, null, this.defaultBG).toRGB());
        }
        return new TextAttribute(fg, bg, attr.style);
    }

    private DelayedTextAttribute merge(DelayedTextAttribute childAttr, DelayedTextAttribute parentAttr) {
        return new DelayedTextAttribute(this.merge(childAttr.foreground, parentAttr.foreground, this.defaultFG), this.merge(childAttr.background, parentAttr.background, this.defaultBG), childAttr.style | parentAttr.style);
    }

    private RGBa merge(RGBa top, RGBa bottom, RGB defaultParent) {
        if (top == null && bottom == null) {
            return new RGBa(defaultParent);
        }
        if (top == null) {
            return bottom;
        }
        if (top.isFullyOpaque()) {
            return top;
        }
        if (bottom == null) {
            return new RGBa(Theme.alphaBlend(defaultParent, top.toRGB(), top.getAlpha()));
        }
        return new RGBa(Theme.alphaBlend(bottom.toRGB(), top.toRGB(), top.getAlpha()));
    }
}

